/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Defines a single dispatch
 * method that allows programmers to pass extra context information
 * around in a RequestContext object. Thus, when dispatcher A chains
 * to dispatcher B, dispatcher B can determine what portion of the
 * original request URL it needs to work with and what portion just
 * made dispatcher A chain to dispatcher B. This context information
 * allows a dispatcher to dynamically hand off a request to another
 * dispatcher.
 *
 * A dispatcher is an <em>entry point</em> for a package.  Each package
 * defines a dispatcher, which brokers out requests within the package.
 * The dispatcher for a package can dispatch requests to other packages.
 * Multiple packages can share the same dispatcher <em>type</em> but
 * not instance.<p>
 *
 * If a dispatcher object for a package also implements HttpServlet,
 * then it is also an entry point for the entire web application.
 *
 * @author Bill Schneider 
 * @version ACS 4.5
 * @since 4.5 */

public interface Dispatcher {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/Dispatcher.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Dispatches this request.
     * @param request the servlet request object
     * @param response the servlet response object
     * @param actx the request context
     * @exception java.io.IOException may be thrown by the dispatcher
     * to indicate an I/O error
     * @exception javax.servlet.ServletException may be thrown by the
     *  dispatcher to propagate a generic error to its caller
     */
    public void dispatch(HttpServletRequest request,
                         HttpServletResponse response,
                         RequestContext actx)
        throws IOException, ServletException;
}
