/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.core;

import com.arsdigita.packaging.Check;
import com.arsdigita.runtime.*;
import com.arsdigita.util.*;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 * BaseCheck
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/

abstract class BaseCheck extends Check {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/core/BaseCheck.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final MessageMap s_messages = new MessageMap();

    static {
        final InputStream in = BaseCheck.class.getResourceAsStream
            ("checks.messages_linux");

        Assert.exists(in, InputStream.class);

        s_messages.load(new InputStreamReader(in));
    }

    static String message(final String key) {
        Assert.exists(key, String.class);

        return s_messages.get(key);
    }

    PrintStream m_out = System.out;
    ClassLoader m_loader =
        Thread.currentThread().getContextClassLoader();
    boolean m_verbose = false;

    void printClassLocations(final String classname) {
        final Iterator urls = getClassURLs(classname).iterator();

        while (urls.hasNext()) {
            final String url = ((URL) urls.next()).toString();

            final int end = url.indexOf("!");

            if (end != -1) {
                if (url.startsWith("jar:file:")) {
                    m_out.println("    " + url.substring(9, end));
                } else {
                    m_out.println("    " + url.substring(0, end));
                }
            } else {
                m_out.println("    " + url);
            }
        }
    }

    List getClassURLs(final String classname) {
        return getResourceURLs(classname.replace('.', '/') + ".class");
    }

    List getResourceURLs(final String resource) {
        final ArrayList list = new ArrayList();

        try {
            final Enumeration resources = m_loader.getResources(resource);

            while (resources.hasMoreElements()) {
                list.add(resources.nextElement());
            }
        } catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }

        return list;
    }

    boolean isClassFound(final String classname) {
        if (m_verbose) {
            m_out.println("Looking for class " + classname);
        }

        try {
            final Class clacc = m_loader.loadClass(classname);

            if (m_verbose) {
                m_out.println
                    ("Found class at " + getClassURLs(classname).get(0));
            }

            return true;
        } catch (ClassNotFoundException nfe) {
            m_out.println("Class not found");

            return false;
        }
    }

    void checkDuplicates(final String classname) {
        if (m_verbose) {
            m_out.println("Checking for duplicates of " + classname);
        }

        if (getClassURLs(classname).size() > 1) {
            if (m_verbose) {
                m_out.println("Duplicates found");
            }

            m_out.println(message("duplicate_classes"));
            m_out.println();
            printClassLocations(classname);
        } else {
            if (m_verbose) {
                m_out.println("No duplicates");
            }
        }
    }

}
