/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;

import com.arsdigita.kernel.*;

/**
 *
 * This is thrown when an attempt is made to add a mapping that already exists.
 *
 * @author Randy Graebner
 * @version $Revision: #10 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class CategoryMappingExistsException extends CategorizationException {
    private ACSObject acsObject = null;
    private Category category = null;

    public CategoryMappingExistsException(String message) {
        super(message);
    }


    public CategoryMappingExistsException(Exception e) {
        this(e.getMessage());
    }


    /**
     * Sets the offending object.
     */
    public void setObject(ACSObject object) {
        acsObject = object;
    }


    /**
     * Sets the parent category from the mapping.
     */
    public void setCategory(Category cat) {
        category = cat;
    }


    /**
     * Returns the object that caused this exception.
     */
    public ACSObject getObject() {
        return acsObject;
    }


    /**
     * Returns the category for which the exception was thrown.
     */
    public Category getCategory() {
        return category;
    }
}
