/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.tree;





/**
 *  The interface
 * describes a node for a tree.
 *
 * @author David Lutterkort 
 * @author Stanislav Freidin 
 * @author Tri Tran 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/tree/TreeNode.java#9 $ */
public interface TreeNode {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/tree/TreeNode.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Obtain a unique ID representing the node
     */
    Object getKey();

    /**
     * Get the element of the tree node.  The concrete type
     * of the object returned is specific to each implementation
     * of the <code>TreeModel</code> and should be documented
     * there.
     *
     * @return the element for the tree node
     */
    Object getElement();
}
