/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.tree;

import com.arsdigita.bebop.PageState;
import java.util.Iterator;

/**
 *  The interface
 * describes a model for a tree structure.
 *
 * @author David Lutterkort 
 * @author Stanislav Freidin 
 * @author Tri Tran 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/tree/TreeModel.java#9 $ */
public interface TreeModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/tree/TreeModel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Obtain the root node of the tree, passing
     * in PageState for permissioning purposes
     */
    TreeNode getRoot(PageState data);

    /**
     * Check whether the node has children
     */
    boolean hasChildren(TreeNode n, PageState data);

    /**
     * Check whether a given node has children, passing
     * in PageState for permissioning purposes
     */
    Iterator getChildren(TreeNode n, PageState data);
}
