/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.portal;

import com.arsdigita.bebop.PageState;

/**
 *  <p>Acts as the
 * go-between for {@link Portal}s and {@link PortalModel}s.  A class
 * implementing this interface, usually an anonymous inner class, is
 * passed into Portal's constructor.  Portal calls
 * PortalModelBuilder's {@link #buildModel} method to get a
 * PortalModel for the current request.  See {@link Portal} for some
 * sample code.</p>
 *
 * @see Portal
 * @see PortalModel
 * @see PortletRenderer
 * @see AbstractPortletRenderer
 * @author Justin Ross
 * @author James Parsons */
public interface PortalModelBuilder {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/portal/PortalModelBuilder.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Build a {@link PortalModel} for the current request.
     *
     * @param pageState represents the current request.
     * @pre pageState != null
     * @post return != null
     */
    PortalModel buildModel(PageState pageState);
}
