/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import javax.servlet.http.HttpServletRequest;

/**
 * A string parameter. The value for this parameter model is copied
 * verbatim from the request. This parameter will never cause a validation
 * error.
 *
 * @author Karl Goldstein
 * @author Uday Mathur
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/StringParameter.java#7 $
 */
public class StringParameter extends ParameterModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/StringParameter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Create a new parameter which is filled from the request parameter
     * with the given name.
     *
     * @param name the name of the request parameter from which the string
     * is read.
     */
    public StringParameter(String name) {
        super(name);
    }

    /**
     * Retrieve the string from its request parameter. The returned object
     * is of class {@link java.lang.String}. If the request parameter is
     * not present, <code>null</code> is returned.
     *
     * @param request represents the current request
     * @return the {@link java.lang.String} from the request parameter or
     * <code>null</code> if the parameter does not occur in the request.
     */
    public Object transformValue(HttpServletRequest request) {
        return transformSingleValue(request);
    }

    public Object unmarshal(String encoded) {
        return encoded;
    }

    public Class getValueClass() {
        return String.class;
    }

}
