/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.page;

import com.arsdigita.bebop.Page;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.Assert;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 * Class for dispatching a single Bebop page object.  Generates the
 * XML output for a Bebop page and renders it with an XSL template.
 */
public class PageDispatcher implements Dispatcher {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/bebop/page/PageDispatcher.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(PageDispatcher.class);

    private final Page m_page;
    private final PresentationManager m_pres;

    /**
     * Creates a new page dispatcher for a page object and a
     * PresentationManager.
     */
    public PageDispatcher(final Page page,
                          final PresentationManager pres) {
        m_page = page;
        m_pres = pres;
    }

    /**
     * Creates a new page dispatcher for a page object.  Uses the
     * default presentation manager.
     */
    public PageDispatcher(final Page page) {
        m_page = page;
        m_pres = Templating.getPresentationManager();
    }

    /**
     * Serves the Bebop page using the specified
     * <code>PresentationManager</code>.
     */
    public void dispatch(final HttpServletRequest req,
                         final HttpServletResponse resp,
                         final RequestContext ctx)
            throws IOException, ServletException {
        Assert.exists(m_pres, PresentationManager.class);

        DeveloperSupport.startStage("Dispatcher page.buildDocument");
        com.arsdigita.xml.Document doc = m_page.buildDocument(req, resp);
        DeveloperSupport.endStage("Dispatcher page.buildDocument");

        DeveloperSupport.startStage("Dispatcher presMgr.servePage");
        m_pres.servePage(doc, req, resp);
        DeveloperSupport.endStage("Dispatcher presMgr.servePage");
    }

    /**
     * Returns the wrapped page that this dispatcher serves.
     *
     * @return the wrapped <code>Page</code> object
     */
    public Page getPage() {
        return m_page;
    }
}
