/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import org.w3c.dom.Node;

/**
 * JSP tag handler to show the current item within a show:list
 * or show:table tag.  For aesthetics in naming it may be mapped to
 * more than one JSP tag.
 *
 * <p>
 * sample Usage:
 *  <pre>
 * &lt;show:list name="mylist">
 *    show list item here <show:listItem/>
 * &lt;show:list name="mylist">
 * </pre>
 *
 *  <pre>
 * &lt;show:row name="mylist">
 *    show table column value <show:col/>
 * &lt;show:row name="mylist">
 * </pre>
 *
 * This has the effect of locally-styling the list contents in the JSP,
 * while globally styling the individual item inside the list.
 */
public class ShowListItem extends ShowComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/ShowListItem.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public int doEndTag() {
        // we don't have a named component, but we find our parent
        // show:list tag copy the contents of the current cell over
        // into our result output context.
        ShowCellList tag = (ShowCellList)findAncestorWithClass
            (this, ShowCellList.class);
        Node n = tag.getCurrentCell();
        Node toAdd = getResultDocument().importNode(n, true);
        ShowContainer parent = getContainerTag();
        parent.getOutputContext().appendChild(toAdd);
        return EVAL_PAGE;
    }
}
