/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.templating.Templating;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.apache.log4j.Logger;

/**
 * A simple replacement for ShowPage which simply
 * passes the input document from DefinePage straight
 * through to the presentation manager. So rather than
 * having to put a &lt;show:component&gt; tag for every
 * &lt;define:component&gt; tag, you simply need a single
 * &lt;show:all&gt; tag.
 */

public class ShowAll extends ShowContainer {

    public static final Logger s_log = Logger.getLogger(ShowAll.class);

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/ShowAll.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private com.arsdigita.xml.Document m_resultDoc;
    private com.arsdigita.xml.Document m_inputDoc;
    private Document m_resultDom;
    private Document m_inputDom;
    private Node m_inputContext;
    private Node m_outputContext;

    /**
     * Creates a new result document
     */
    public int doStartTag() throws JspException {
        HttpServletResponse resp =
            (HttpServletResponse)pageContext.getResponse();
        if (resp.isCommitted()) {
            s_log.debug("Already committed, so skiping");
            // we already committed the response (redirect).  Don't bother
            // trying to do anything with output
            return SKIP_BODY;
        }

        m_inputDoc = (com.arsdigita.xml.Document)pageContext.getRequest()
            .getAttribute(INPUT_DOC_ATTRIBUTE);
        m_resultDoc = m_inputDoc;
        
        if (s_log.isDebugEnabled()) {
            s_log.debug("Outputing doc " + pageContext.getRequest() + 
                        " " + m_resultDoc.toString(true));
        }

        m_inputDom = m_inputDoc.getInternalDocument();
        m_resultDom = m_inputDom;

        Element pageElement = m_inputDom.getDocumentElement();
        Node resultPageNode = m_resultDom.getDocumentElement();

        m_outputContext = resultPageNode;
        m_inputContext = pageElement;
        return EVAL_BODY_TAG;
    }

    /**
     * Serves the result document with a presentation manager.
     */
    public int doEndTag() throws JspException {
      servePageWithPresentationManager();
      return EVAL_PAGE;
    }

    Node getInputContext() {
        // package-protected visibility is intentional
        return m_inputContext;
    }

    Node getOutputContext() {
        // package-protected visibility is intentional
        return m_outputContext;
    }

    /**
     * returns the result document that JSP tags are building.  Necessary
     * for calling DOM methods createElement, createTextNode, etc.
     */
    Document getResultDocument() {
        // package-protected visibility is intentional.
        return m_resultDom;
    }

    Document getInputDocument() {
        // package-protected visibility is intentional.
        return m_inputDom;
    }

    // helper method.
    private void servePageWithPresentationManager() {
      HttpServletRequest req =
        (HttpServletRequest)pageContext.getRequest();
      HttpServletResponse resp =
        (HttpServletResponse)pageContext.getResponse();

      Templating.getPresentationManager()
          .servePage(m_resultDoc, req, resp);
    }
}
