/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspException;

public class DefineTextArea extends DefineComponent {

    private TextArea m_textArea;
    private String m_type;
    private int m_rows;
    private int m_cols;
    private int m_wrap;
    private String m_value;

    private final static String s_defaultParameterType =
        "com.arsdigita.bebop.parameters.StringParameter";

    private final static String s_errorMsg =
        "type must be an instance of ParameterModel";
    private final static String s_wrapErrorMessage =
        "wrap must be soft, hard, or off";

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineTextArea.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public int doStartTag() throws JspException {
        ParameterModel pm = null;
        if (m_type == null) {
            m_type = s_defaultParameterType;
        }

        try {
            Class paramClass = Class.forName(m_type);
            Constructor ctor =
                paramClass.getConstructor(new Class[] { String.class });
            pm = (ParameterModel)ctor.newInstance(new Object[] {getName()});
            m_textArea = new TextArea(pm);
        } catch (ClassNotFoundException e) {
            throw new JspWrapperException("cannot find class " + m_type, e);
        } catch (NoSuchMethodException e) {
            throw new JspWrapperException("cannot find (String) constructor in: " + m_type, e);
        } catch (IllegalAccessException e) {
            throw new JspWrapperException("constructor is not public in: " + m_type, e);
        } catch (InstantiationException e) {
            throw new JspWrapperException("class is abstract: " + m_type, e);
        } catch (InvocationTargetException e) {
            throw new JspWrapperException("constructor threw an exception in: " + m_type, e);
        }

        m_textArea.setValue(m_value);
        if (m_rows > 0) {
            m_textArea.setRows(m_rows);
        }
        if (m_cols > 0) {
            m_textArea.setCols(m_cols);
        }
        m_textArea.setWrap(m_wrap);
        // add form to parent
        int ret = super.doStartTag();
        // must put parameter model in page context after calling supereclass
        pageContext.setAttribute(getName(), pm);
        return ret;
    }

    protected final Component getComponent() {
        return m_textArea;
    }

    /**
     * sets the type of the parameter.  The parameter type
     * must be an instance of
     * <code>com.arsdigita.bebop.parameters.ParameterModel</code>.
     * Default is <code>StringParameter</code>.
     */
    public final void setType(String s) {
        m_type = s;
    }

    /**
     * Sets the number of rows in the text box.
     */
    public final void setRows(String s) {
        m_rows = Integer.valueOf(s).intValue();
    }

    /**
     * Sets the number of columns in the text box.
     */
    public final void setCols(String s) {
        m_cols = Integer.valueOf(s).intValue();
    }

    /**
     * Sets the wrap property for the text entry box. Legal values are
     * "off", "hard", and "soft"; these are the same as those for the
     * HTML textarea element.
     *
     * @param s the wrap property */
    public final void setWrap(String s) throws JspException {
        if (s.equals("off")) {
            m_wrap = TextArea.OFF;
        } else if (s.equals("soft")) {
            m_wrap = TextArea.SOFT;
        } else if (s.equals("hard")) {
            m_wrap = TextArea.HARD;
        } else {
            throw new JspException(s_wrapErrorMessage);
        }
    }

    /**
     * sets the default value for the text area.
     */
    public final void setValue(String s) {
        m_value = s;
    }
}
