/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspException;

public class DefineText extends DefineComponent {

    private TextField m_text;
    private String m_type;
    private int m_maxLength;
    private int m_size;

    private final static String s_defaultParameterType =
        "com.arsdigita.bebop.parameters.StringParameter";

    private final static String s_errorMsg =
        "type must be an instance of ParameterModel";

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineText.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public int doStartTag() throws JspException {
        ParameterModel pm = null;
        if (m_type == null) {
            m_type = s_defaultParameterType;
        }

        try {
            Class paramClass = Class.forName(m_type);
            Constructor ctor =
                paramClass.getConstructor(new Class[] { String.class });
            pm = (ParameterModel)ctor.newInstance(new Object[] {getName()});
            m_text = new TextField(pm);
            if (m_size > 0) {
                m_text.setSize(m_size);
            }
            if (m_maxLength > 0) {
                m_text.setMaxLength(m_maxLength);
            }
        } catch (ClassNotFoundException e) {
            throw new JspWrapperException("cannot find class " + m_type, e);
        } catch (NoSuchMethodException e) {
            throw new JspWrapperException("cannot find (String) constructor in: " + m_type, e);
        } catch (IllegalAccessException e) {
            throw new JspWrapperException("constructor is not public in: " + m_type, e);
        } catch (InstantiationException e) {
            throw new JspWrapperException("class is abstract: " + m_type, e);
        } catch (InvocationTargetException e) {
            throw new JspWrapperException("constructor threw an exception in: " + m_type, e);
        }

        // add form to parent
        int ret = super.doStartTag();
        // must put parameter model in page context after calling supereclass
        pageContext.setAttribute(getName(), pm);
        return ret;
    }

    protected final Component getComponent() {
        return m_text;
    }

    /**
     * sets the type of the parameter.  The parameter type
     * must be an instance of
     * <code>com.arsdigita.bebop.parameters.ParameterModel</code>.
     * Default is <code>StringParameter</code>.
     */
    public final void setType(String s) {
        m_type = s;
    }

    public final void setSize(String s) {
        m_size = new Integer(s).intValue();
    }

    public final void setMaxLength(String s) {
        m_maxLength = new Integer(s).intValue();
    }
}
