/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Link;
import javax.servlet.jsp.JspException;

/**
 * Tag handler for definining a Link.
 */
public class DefineLink extends DefineComponent {

    private Link m_link;
    private String m_url;
    private String m_label;

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineLink.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // must override this method because we're not adding the
    // link to the page until the *end* of the tag.  (Otherwise we
    // don't know the contents.)
    public int doStartTag() throws JspException {
        getParentTag().doAfterBody();
        return EVAL_BODY_TAG;
    }

    public int doAfterBody() throws JspException {
        m_label = bodyContent.getString();
        return SKIP_BODY;
    }

    public int doEndTag() throws JspException {
        m_link = new Link(m_label, m_url);
        if (getName() != null) {
            m_link.setIdAttr(getName());
        }
        getParentTag().addComponent(m_link);
        return super.doEndTag();
    }

    protected final Component getComponent() {
        return m_link;
    }

    public void setUrl(String s) {
        m_url = s;
    }
}
