/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Image;
import javax.servlet.jsp.JspException;

/**
 * Tag handler for definining an Image.
 */
public class DefineImage extends DefineComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineImage.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Image m_image;
    private String m_src;
    private String m_alt;
    private String m_height;
    private String m_width;
    private String m_border;

    public int doStartTag() throws JspException {
        m_image = new Image(m_src);
        m_image.setAlt(m_alt);
        m_image.setWidth(m_width);
        m_image.setHeight(m_height);
        m_image.setBorder(m_border);
        return super.doStartTag();
    }

    public Component getComponent() {
        return m_image;
    }

    public void setSrc(String src) {
        m_src = src;
    }

    public void setAlt(String alt) {
        m_alt = alt;
    }

    public void setHeight(String height) {
        m_height = height;
    }

    public void setWidth(String width) {
        m_width = width;
    }

    public void setBorder(String border) {
        m_border = border;
    }
}
