/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;


import com.arsdigita.xml.Element;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterModel;
// This interface contains the XML element name of this class
// in a constant which is used when generating XML
import com.arsdigita.bebop.util.BebopConstants;



/**
 *    A class representing a textarea field in an HTML form.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Rory Solomon 
 *    @author Michael Pih 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/TextArea.java#8 $
 */
public class TextArea extends Widget implements BebopConstants {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/TextArea.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constant for specifying <tt>OFF</tt> value for the
     * <tt>WRAP</tt> attribute of this image input.  See <a
     * href="http://developer.netscape.com/docs/manuals/htmlguid/tags10.htm#1340340">here</a>
     * for a description of what this attribute does.  */

    public static final int OFF = 0;

    /**
     * Constant for specifying <tt>HARD</tt> value for the
     * <tt>WRAP</tt> attribute of this image input.  * See <a
     * //href="http://developer.netscape.com/docs/manuals/htmlguid/tags10.htm#1340340">here</a>
     * for a description of what this attribute does.
     */
    public static final int HARD = 1;

    /**
     * Constant for specifying <tt>SOFT</tt> value for the
     * <tt>WRAP</tt> attribute of this image input.  See <a
     * href="http://developer.netscape.com/docs/manuals/htmlguid/tags10.htm#1340340">here</a>
     * for a description of what this attribute does.
     */
    public static final int SOFT = 2;

    // -------------------------------------
    //        * * * Fields * * *
    // -------------------------------------


    // -------------------------------------
    //        * * * Methods * * *
    // -------------------------------------


    public TextArea(String name) {
        super(name);
    }

    public TextArea(ParameterModel model) {
        super(model);
    }

    /**
     * Convenience constructor
     */
    public TextArea(String name, int rows, int cols, int wrap) {
        super(name);
        setRows(rows);
        setCols(cols);
        setWrap(wrap);
    }

    /**
     * Convenience constructor
     */
    public TextArea(ParameterModel model, int rows, int cols, int wrap) {
        super(model);
        setRows(rows);
        setCols(cols);
        setWrap(wrap);
    }

    /**
     *      Returns a string naming the type of this widget.
     */
    public String getType() {
        return "textarea";
    }

    /**
     *      Sets the <tt>ROWS</tt> attribute for the <tt>TEXTAREA</tt> tag.
     */
    public void setRows(int rows) {
        setAttribute("rows", String.valueOf(rows));
    }

    /**
     *      Sets the <tt>COLS</tt> attribute for the <tt>TEXTAREA</tt> tag.
     */
    public void setCols(int cols) {
        setAttribute("cols", String.valueOf(cols));
    }

    /**
     *      Sets the <tt>COLS</tt> attribute for the <tt>TEXTAREA</tt> tag.
     */
    public void setWrap(int wrap) {
        String wrapString = null;

        switch (wrap) {
        case OFF:
            wrapString = "off";
            break;
        case HARD:
            wrapString = "hard";
            break;
        case SOFT:
            wrapString = "soft";
            break;
        }

        if (wrapString != null) {
            setAttribute("wrap", wrapString);
        }
    }

    /**
     * Set the default value (text)
     * @deprecated [since 17Aug2001] use {@link Widget#setDefaultValue(Object)}
     */
    public void setValue( String text ) {
        this.setDefaultValue(text);
    }

    /**
     * Is this a compound widget?
     * @return false
     */
    public boolean isCompound() {
        return false;
    }

    /** The XML tag.
     *  @return The tag to be used for the top level DOM element
     *  generated for this type of Widget.  */
    protected String getElementTag() {
        return BEBOP_TEXTAREA;
    }

    /**
     * Generates the DOM for the textarea widget
     * <p>Generates DOM fragment:
     * <p><code>&lt;bebop:textarea name=... value=... [onXXX=...]/>
     *  </code>
     */
    public void generateWidget( PageState state, Element parent ) {
        Element textarea = parent.newChildElement(getElementTag(), BEBOP_XML_NS);

        textarea.addAttribute("name", getName());

        String value = getParameterData(state).marshal();
        if ( value == null ) {
            value = "";
        }
        textarea.addAttribute("value", value);
        exportAttributes(textarea);
    }

}
