/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterModel;
// This interface contains the XML element name of this class
// in a constant which is used when generating XML
import com.arsdigita.bebop.util.BebopConstants;

import java.util.Iterator;

import com.arsdigita.xml.Element;

/**
 *     A class
 *    representing an HTML <code>SELECT</code> element.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Rory Solomon 
 *    @author Michael Pih 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/Select.java#8 $ */
public abstract class Select extends OptionGroup implements BebopConstants {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/Select.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public Select(ParameterModel model) {
        super(model);
        m_xmlElement = BEBOP_OPTION;
    }

    /**
     *  Returns a string naming the type of this widget.
     */
    public String getType() {
        return "select";
    }

    /**
     * Set the HTML size attribute of this widget.
     *
     * @param n The number of visible rows in the widget
     */
    public void setSize(int n) {
        setAttribute("size", Integer.toString(n));
    }

    /**
     *      Callback method for rendering this Select widget in a visitor.
     */
    /*  public void accept(FormVisitor visitor) throws IOException {
        visitor.visitSelect(this);
        }*/

    /** The XML tag.
     *  @return The tag to be used for the top level DOM element
     *  generated for this type of Widget.  */
    protected abstract String getElementTag();

    /**
     * Generates the DOM for the select widget
     * <p>Generates DOM fragment:
     * <p><pre><code>&lt;bebop:*select name=... [onXXX=...]>
     *   &lt;bebop:option name=... [selected]> option value &lt;/bebop:option>
     * ...
     * &lt;/bebop:*select></code></pre>
     */
    public void generateWidget( PageState state, Element parent ) {
        Element select = parent.newChildElement(getElementTag(), BEBOP_XML_NS);
        select.addAttribute("name", getName());
        if (isMultiple()) {
            select.addAttribute("multiple", "multiple");
        }
        exportAttributes(select);

        for ( Iterator i = getOptions(state); i.hasNext(); ) {
            Option o = (Option)i.next();
            o.generateXML(state, select);
        }
    }

}
