/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.parameters.ParameterModel;

/**
 *    A class representing an image HTML form element.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Rory Solomon 
 *    @author Michael Pih 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/ImageSubmit.java#7 $
 */
public class ImageSubmit extends Widget {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/ImageSubmit.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     *      Constant for specifying LEFT alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    //    public static final int LEFT = 0;

    /**
     *      Constant for specifying RIGHT alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    //   public static final int RIGHT = 1;

    /**
     *      Constant for specifying TOP alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    //  public static final int TOP = 2;

    /**
     *      Constant for specifying ABSMIDDLE alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    // public static final int ABSMIDDLE = 3;

    /**
     *      Constant for specifying ABSBOTTOM alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    //public static final int ABSBOTTOM = 4;

    /**
     *      Constant for specifying TEXTOP alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    // public static final int TEXTTOP = 5;

    /**
     *      Constant for specifying MIDDLE alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    // public static final int MIDDLE = 6;

    /**
     *      Constant for specifying BASELINE alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    //public static final int BASELINE = 7;

    /**
     *      Constant for specifying BOTTOM alignment of this image input.
     *      See <a href="http://www.w3.org/TR/html4/present/graphics.html#alignment">here</a>
     *      for a description of what this attribute does.
     */
    //public static final int BOTTOM = 8;

    public ImageSubmit(String name) {
        super(name);
    }

    public ImageSubmit(ParameterModel model) {
        super(model);
    }

    /**
     *      Returns a string naming the type of this widget.
     */
    public String getType() {
        return "image";
    }

    /**
     *      Sets the <tt>SRC</tt> attribute for the <tt>INPUT</tt> tag
     *      used to render this form element.
     */
    public void setSrc(String location) {
        setAttribute("src",location);
    }

    /*
     * Sets the <tt>ALRT</tt> attribute for the <tt>INPUT</tt> tag
     * used to render this form element.
     */
    public void setAlt(String alt) {
        setAttribute("alt",alt);
    }

    /**
     *      Sets the <tt>ALIGN</tt> attribute for the <tt>INPUT</tt> tag
     *      used to render this form element.
     */
    public void setAlign(int align) {
        String alignString = null;

        switch (align) {
        case LEFT:
            alignString = "left";
            break;
        case RIGHT:
            alignString = "right";
            break;
        case TOP:
            alignString = "top";
            break;
        case ABSMIDDLE:
            alignString = "absmiddle";
            break;
        case ABSBOTTOM:
            alignString = "absbottom";
            break;
        case TEXTTOP:
            alignString = "texttop";
            break;
        case MIDDLE:
            alignString = "middle";
            break;
        case BASELINE:
            alignString = "baseline";
            break;
        case BOTTOM:
            alignString = "botton";
            break;
        }

        if (alignString != null)
            setAttribute("align",alignString);
    }

    public boolean isCompound() {
        return false;
    }

    /**
     *      Callback method for rendering this Image widget in a visitor.
     */
    /*  public void accept(FormVisitor visitor) throws IOException {
        visitor.visitImage(this);
        }*/


}
