/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.PageErrorDisplay;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.util.LockableImpl;

import java.util.Collections;

/**
 * Displays validation errors on the form which were added by the form's
 * validation listener. Does not handle errors in the individual parameters;
 * these errors are handled by the form's template. This class is not
 * a form widget, since it does not produce a value.
 *
 *    @author Stanislav Freidin 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/FormErrorDisplay.java#8 $
 *
 */
public class FormErrorDisplay extends PageErrorDisplay  {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/FormErrorDisplay.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Form m_form;

    /**
     * Construct a new <code>FormErrorDisplay</code>
     *
     * @param form The parent form whose errors will be displayed by
     *   this widget
     */
    public FormErrorDisplay(Form form) {
        super(new FormErrorModelBuilder(form));
        m_form = form;
    }

    /**
     * Return the form whose errors are to be displayed
     * @return the form whose errors are to be displayed
     */
    public final Form getForm() {
        return m_form;
    }

    /**
     * Determine if there are errors to display
     *
     * @param state the current page state
     * @return true if there are any errors to display; false otherwise
     */
    protected boolean hasErrors(PageState state) {
        FormData data = m_form.getFormData(state);
        return (data != null && data.getErrors().hasNext());
    }

    // A private class which builds a ListModel based on form errors
    private static class FormErrorModelBuilder extends LockableImpl
        implements ListModelBuilder {

        private Form m_form;

        public FormErrorModelBuilder(Form form) {
            super();
            m_form = form;
        }

        public ListModel makeModel(List l, PageState state) {
            FormData data = m_form.getFormData(state);
            if(data == null) {
                return new StringIteratorModel(Collections.EMPTY_LIST.iterator());
            } else {
                return new StringIteratorModel(data.getErrors());
            }
        }
    }

}
