/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;

/**
 * An event for the {@link com.arsdigita.bebop.Table} component.
 * Table will fire this event when one of its active cells receives a
 * click.
 *
 * @see TableActionListener
 * @see TableActionAdapter
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/TableActionEvent.java#8 $
 */
public class TableActionEvent extends ActionEvent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/TableActionEvent.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Object m_rowKey;
    private Integer m_column;

    /**
     * Construct a TableActionEvent for a click on a particular row
     * and a particular column.
     *
     * @param source the Component generating the event.
     * @param s the state for the current request.
     * @param rowKey the key for the row where the click was registered.
     * @param column the index of the column where the click was registered.
     */
    public TableActionEvent(Component source, PageState s,
                            Object rowKey, Integer column) {
        super(source, s);
        m_rowKey = rowKey;
        m_column = column;
    }

    /**
     * Construct a TableActionEvent for a click on a particular row.
     *
     * @param source the Component generating the event.
     * @param s the state for the current request.
     * @param rowKey the key for the row where the click was registered.
     */
    public TableActionEvent(Component source, PageState s, Object rowKey) {
        this(source, s, rowKey, new Integer(-1));
    }

    /**
     * Get the key for the row that received the click.
     *
     * @return the key for the row that received the click.
     */
    public final Object getRowKey() {
        return m_rowKey;
    }

    /**
     * Get the index of the column that received the click.
     *
     * @return the index of the column that received the click.
     */
    public final Integer getColumn() {
        return m_column;
    }
}
