/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import java.util.EventListener;

/**
 *  Analogous to Widget
 * PrintListeners, this is called when the widget is displayed (or
 * validated) to get the dataset.  The dataset should be created
 * dynamically so it can vary according to form variables.
 * Eventually, this may also support setting the initial value for a
 * SearchAndSelect widget, so that it may act as an edit widget as
 * well.
 *
 * @author Patrick McNeill
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/SearchAndSelectListener.java#8 $
 * @since 4.5 */
public interface SearchAndSelectListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/SearchAndSelectListener.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    SearchAndSelectModel getModel( PageEvent e );
}
