/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.PageState;

import java.util.EventObject;

/**
 * The base class for all page related events. All page related events
 * should be derived from this class, since it defines a standard way to
 * get at the source of the event and at the state of the page under the
 * request that is currently being processed.
 *
 * @author David Lutterkort 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/PageEvent.java#7 $
 */
public class PageEvent extends EventObject {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/PageEvent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private transient PageState _state;

    /**
     * Construct a new <code>PageEvent</code>.
     * @param source the object firing the event, usually a {@link
     * com.arsdigita.bebop.Component <code>Component</code>}.
     * @param state the state of the page under the current request
     */
    public PageEvent(Object source, PageState state) {
        super(source);
        _state = state;
    }

    /**
     * Get the state of the page under the request in which the event was fired
     */
    public final PageState getPageState() {
        return _state;
    }

}
