/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.FormProcessException;
import java.util.EventListener;

/**
 *    Defines the interface for a class that performs cleanup after
 *    cancelling out of a form
 *
 *    @author Kevin Scaldeferri 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormCancelListener.java#7 $
 */

public interface FormCancelListener extends EventListener {

    /**
     * Performs any necessary cleanup after a user cancels out of
     * a form
     *
     * <p>Implementations of this method are responsible for catching
     * specific exceptions that may occur during processing, and either
     * handling them internally or rethrowing them as instances of
     * <code>FormProcessException</code> to be handled by the calling
     * procedure.
     */

    void cancel(FormSectionEvent e) throws FormProcessException;

}
