/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo.workflow;


import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.util.GlobalizationUtil;


public class AddProcess extends Form
    implements FormProcessListener, FormInitListener,
               FormSubmissionListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/AddProcess.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private SingleSelectionModel m_processes;
    private ToggleLink m_addLink;

    private Hidden m_id;
    private TextField m_title;
    private TextArea m_descr;

    private Submit m_save;
    private Submit m_cancel;

    /** Constructor: set up the form, consisting of a hidden id field,
     *  title, description, and buttons to save or cancel */
    public AddProcess(SingleSelectionModel m, ToggleLink addLink) {
        super("addProcess");

        m_processes = m;
        m_addLink = addLink;

        addInitListener(this);
        addProcessListener (this);
        addSubmissionListener(this);

        m_id = new Hidden("id");
        add(m_id);
        m_id.addValidationListener(new NotNullValidationListener());

        add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.process_name")));
        m_title = new TextField("title");
        m_title.addValidationListener(new NotNullValidationListener());
        add(m_title);

        add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.short_description")));
        m_descr = new TextArea("desc") ;
        m_descr.setRows(3);
        m_descr.setCols(40);

        add(m_descr);

        m_save = new Submit("save", "Save");
        m_cancel = new Submit("cancel", "Cancel");

        add(m_save, ColumnPanel.LEFT);
        add(m_cancel, ColumnPanel.RIGHT);
    }

    /** The main action of the form.  Mandated by the {@link
     *  FormProcessListener} interface.  See {@link
     *  FormProcessListener#process method documentation}. */
    public void process(FormSectionEvent e)
        throws FormProcessException {
        PageState s = e.getPageState();

        if ( m_save.isSelected(s) ) {
            String key = (String) m_id.getValue(s);
            String title = (String) m_title.getValue(s);

            Process p = new Process(key, title);
            p.setDescription((String) m_descr.getValue(s));

            SampleProcesses.getInstance().add(p);

            m_processes.setSelectedKey(s, key);
        }
    }


    /** Check if we want to examine the submission.
     *  Mandated by the {@link FormSubmissionListener} interface.
     *  See {@link FormSubmissionListener#submitted method documentation}. */
    public void submitted(FormSectionEvent e)
        throws FormProcessException {
        PageState s = e.getPageState();

        if ( m_cancel.isSelected(s) ) {
            m_addLink.setSelected(s, false);
            throw new FormProcessException("Cancel hit");
        }
    }

    /** Initialize form data.  Mandated by the {@link
     *  FormInitListener} interface.  See {@link FormInitListener#init
     *  method documentation}. */
    public void init(FormSectionEvent e) {
        m_id.setValue(e.getPageState(), Process.getNextKey());
    }

}
