/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

/**
 * This is a common page for a fictitious MySite.
 * It includes a common header, a footer, and a main "content"
 * area.  We override the .generateXML method to add stuff to the
 * main content area.
 */
public class MySitePage extends Page {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/MySitePage.java#12 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(MySitePage.class);

    private Component m_top;
    private Component m_bottom;
    private Component m_side;

    public MySitePage() {
        this("");
    }

    public MySitePage(String s) {
        super("MySite: " + s);

        m_top = new MySiteHeader();
        m_bottom = new MySiteFooter();
        m_side = new MySiteSide();
    }

    public void generateXML(PageState ps, Document doc) {
        Element page = generateXMLHelper(ps, doc);
        Element layout = new Element("bebop:fourPanelLayout", BEBOP_XML_NS);
        page.addContent(layout);

        addContents(layout, ps);
    }

    protected void addContents(Element layout, PageState ps) {
        Element topPanel = new Element("bebop:top", BEBOP_XML_NS);
        layout.addContent(topPanel);
        m_top.generateXML(ps, topPanel);

        Element sidePanel = new Element("bebop:side", BEBOP_XML_NS);
        layout.addContent(sidePanel);
        m_side.generateXML(ps, sidePanel);

        Element bottomPanel = new Element("bebop:bottom", BEBOP_XML_NS);
        layout.addContent(bottomPanel);
        m_bottom.generateXML(ps, bottomPanel);

        Element mainPanel = new Element("bebop:main", BEBOP_XML_NS);
        layout.addContent(mainPanel);
        m_panel.generateXML(ps, mainPanel);
    }

    /**
     * Header component.  Demonstrates dynamic content.
     */
    private class MySiteHeader extends SimpleComponent {
        public void generateXML(PageState ps, Element parent) {
            Element elt = new Element("bebop:message", BEBOP_XML_NS);

            elt.setText("MySite: dynamic page header.  You requested: " +
                        Web.getContext().getRequestURL());

            parent.addContent(elt);
        }
    }

    /**
     * Footer component.  All static.
     */
    private class MySiteFooter extends SimpleComponent {
        public void generateXML(PageState ps, Element parent) {
            Element elt = new Element("bebop:message", BEBOP_XML_NS);
            elt.setText("MySite: static footer.");
            parent.addContent(elt);
        }
    }

    /**
     * Footer component.  All static.
     */
    private class MySiteSide extends SimpleComponent {
        public void generateXML(PageState ps, Element parent) {
            Element elt = new Element("bebop:message", BEBOP_XML_NS);
            elt.setText("MySite: static side panel.");
            parent.addContent(elt);
        }
    }
}
