/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.globalization.GlobalizedMessage;

/**
 * An abstraction that the
 * {@link PropertySheet} class uses to display a
 * 2-column table of label-value pairs.
 *
 * @author Stanislav Freidin 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/PropertySheetModel.java#9 $
 * @see PropertySheetModelBuilder
 */

public interface PropertySheetModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PropertySheetModel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Advances to the next property, if possible.
     *
     * @return <code>false</code> if there are no more properties;
     * <code>true</code> otherwise.
     */
    boolean nextRow();

    /**
     * Returns the label for the current property.
     *
     * @return the current label.
     * @deprecated use getGlobalizedLabel() instead 
     */
    String getLabel();

    /**
     *  Returns the GlobalizedMessage for the current property
     *  @return the current GlobalizedMessage
     */
    GlobalizedMessage getGlobalizedLabel();


    /**
     * Returns the string representation of the current property.
     *
     * @return the current value formatted as a string.
     */
    String getValue();

}
