/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.xml.Element;

/**
 *  <p>An interface specifying {@link Component}-like behavior for a
 * Portlet, insofar as XML generation is concerned.  Since a Portlet
 * gets its state only from {@link
 * com.arsdigita.bebop.portal.PortalModel}, it is stateless from the
 * Bebop point of view and does not need Component's state management.
 * We do still, however, want Portlet to produce XML just as other
 * Components do.</p>
 *
 * <p>The Portlet interface is used in {@link com.arsdigita.bebop.portal.Portal} when it builds a
 * new {@link com.arsdigita.bebop.portal.PortalModel} and fetches a set of Portlets.  Portal
 * calls {@link #generateXML} on each Portlet returned.</p>
 *
 * <p>Implementers of Portlets will ordinarily want to
 * extend {@link AbstractPortlet} since it provides a default XML
 * frame for portlets that the Portal stylesheet knows to
 * transform.</p>
 *
 * @see com.arsdigita.bebop.portal.Portal
 * @see com.arsdigita.bebop.portal.PortalModel
 * @see com.arsdigita.bebop.portal.PortalModelBuilder
 * @see AbstractPortlet
 * @author Justin Ross 
 * @author James Parsons 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/Portlet.java#10 $ */
public interface Portlet {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Portlet.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Builds an XML fragment and attaches it to this component's parent.
     * Someone implementing a TimeOfDayPortlet could, for instance,
     * override this method to fetch the time and wrap it in a
     * Bebop {@link Label}.  However, it is preferable to
     * extend {@link AbstractPortlet}, since it provides a default "XML
     * wrapper" for portlets.
     *
     * @param pageState the PageState of the current request
     * @param parentElement the element to which to attach the XML this
     * method creates
     * @pre pageState != null
     * @pre parentElement != null
     */
    void generateXML(PageState pageState, Element parentElement);
}
