/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import java.util.Iterator;

import com.arsdigita.xml.Element;

/**
 * A container that outputs its components in a &lt;list&gt;. Each child is
 * printed in its own list item.  The components are put into the list
 * in the order in which they were added to the
 * <code>ListPanel</code>, progressing from top to bottom.
 *
 * <p> ListPanels can be ordered or unordered.</p>
 *
 * @author Christian Brechb&uuml;hler (christian@arsdigita.com)
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/ListPanel.java#6 $
 * */
public class ListPanel extends SimpleContainer  {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ListPanel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final boolean ORDERED   = true ;
    public static final boolean UNORDERED = false;
    private boolean m_ordered;

    /**
     * Creates a simple list.
     * @param ordered <code>true</code> is an ordered (numbered) list;
     * <code>false</code> is an unordered (bulleted) list
     *
     */
    public ListPanel(boolean ordered) {
        m_ordered = ordered;
    }

    /**
     * Adds child components as a subtree under list-item nodes.
     * <p>Generates a DOM fragment:
     * <p><pre>
     * &lt;bebop:listPanel>
     *   &lt;bebop:cell> ... cell contents &lt;/bebop:cell>
     *   &lt;bebop:cell> ... cell contents &lt;/bebop:cell>
     *   ...
     * &lt;/bebop:list></pre></p>
     * @param state the state of the current request
     * @param parent the node under which this subtree will be added
     */
    public void generateXML(PageState state, Element parent) {

        if ( ! isVisible(state) ) {
            return;
        }

        Element list = parent.newChildElement("bebop:listPanel", BEBOP_XML_NS);
        list.addAttribute("ordered", String.valueOf(m_ordered));
        exportAttributes(list);

        // generate XML for children
        for (Iterator i = children(); i.hasNext(); ) {
            Component c = (Component) i.next();

            Element item  = list.newChildElement("bebop:cell", BEBOP_XML_NS);
            c.generateXML(state, item);
        }
    }
}
