/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;



/**
 * A link that runs its action listeners when it is clicked. The target of the
 * link is the {@link Page} in which the action link is contained.
 *
 * <p> Typically, an action link is used in the following way:
 * <pre>
 *   ActionLink l = new ActionLink("Send email to everybody");
 *   l.addActionListener(new ActionListener() {
 *      public void actionPerformed(ActionEvent e) {
 *        System.out.println("Link was clicked.");
 *        ... figure out who everybody is and send them email ...
 *      }
 *   });
 * </pre>
 *
 * <p>See {@link BaseLink} for a description of all Bebop Link classes
 * and suggestions for using them.
 *
 * @author David Lutterkort 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/ActionLink.java#7 $ */
public class ActionLink extends ControlLink {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ActionLink.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * The value for the XML type attribute for an {@link ActionLink}.
     */
    protected final String TYPE_ACTION = "action";

    /**
     * Constructs a new ActionLink. The link encapsulates
     * the child component (usually either a label or an image).
     *
     * @param child the component to be turned into a link
     */
    public ActionLink(Component child) {
        super(child);
        setTypeAttr(TYPE_ACTION);
    }

    /**
     * Constructs a new ActionLink with the given string label.
     *
     * @param label the string label for the link
     */
    public ActionLink(String label) {
        this(new Label(label));
    }

    /**
     * Sets the page state's control event. Should be overridden by child
     * classes. By default, the link does not receive any control events.
     *
     * @param s the current page state
     */
    public void setControlEvent(PageState s) {
        s.setControlEvent(this);
    }

}
