/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.auditing;

import com.arsdigita.kernel.User;
import com.arsdigita.web.Web;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 * Interface for auditing save information.
 *  <p>
 *    
 *  </p>
 *
 * @author Joseph Bank 
 * @version 1.0
 **/
public class WebAuditingSaveInfo implements AuditingSaveInfo {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/auditing/WebAuditingSaveInfo.java#11 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (WebAuditingSaveInfo.class);

    private User m_user;
    private Date m_date;
    private String m_ip;

    public WebAuditingSaveInfo() {
        m_user = Web.getContext().getUser();
        // The user may be null.
        
        HttpServletRequest req = Web.getRequest();

        if (req == null) {
            m_ip = "127.0.0.1";
        } else {
            m_ip = req.getRemoteAddr();
        }

        m_date = new Date();
    }

    public User getSaveUser() {
        return m_user;
    }

    public Date getSaveDate() {
        return m_date;
    }

    public String getSaveIP() {
        return m_ip;
    }

    public AuditingSaveInfo newInstance() {
        return new WebAuditingSaveInfo();
    }
}
