/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlutil;

import org.jdom.Namespace;
import org.jdom.Element;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Iterator;
import java.util.LinkedList;
import java.io.StringWriter;
import java.io.PrintWriter;


public class TestSet extends Element {
    public static final String NAME = "test_set";
    private static Logger s_log = Logger.getLogger(TestSet.class);

    public TestSet() {
        this( NAME, Namespaces.TEST );
    }
    public TestSet(String name) {
        super(NAME, Namespaces.TEST);
    }
    public TestSet(String name, Namespace ns) {
        super(NAME, Namespaces.TEST);
    }
    public TestSet(String name, String uri) {
        super(NAME, Namespaces.TEST);
    }
    public TestSet(String name, String prefix, String uri) {
        super(NAME, Namespaces.TEST);
    }

    public void runTests() throws Exception {
        List testDefs = this.getChildren("test_def", Namespaces.TEST);
        s_log.warn("Test set has " + testDefs.size() + " elements");
        for (Iterator iterator = testDefs.iterator(); iterator.hasNext();) {
            TestDefinition def = (TestDefinition) iterator.next();
            def.runTest();
        }
     }



}
