/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.web.PathMapCache.LongestMatch;
import com.arsdigita.web.PathMapCache.LongestMatchException;

import junit.framework.TestCase;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/**
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2004-01-14
 * @version $Revision: #3 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public class PathMapCacheTest extends TestCase {

    public PathMapCacheTest(String name) {
        super(name);
    }

    public void testLongestMatch() {
        try {
            new LongestMatch(null);
            fail("should've choked on null");
        } catch (NullPointerException ex) {
            ;
        }

        try {
            new LongestMatch("/foo");
            new LongestMatch("foo/");
            fail("should've complained about a missing slash");
        } catch (LongestMatchException ex) {
            ;
        }

        final String path = "/foo/bar/baz//quux/";
        List elems = Arrays.asList
            (new String[] {path, "/foo/bar/baz//", "/foo/bar/baz/",
                           "/foo/bar/", "/foo/", "/"});
        testLongestMatch(path, elems);

        final String path2 = "/content/";
        testLongestMatch(path2, Arrays.asList(new String[] {path2, "/"}));

        testLongestMatch("/", Arrays.asList(new String[] {"/"}));
    }

    private void testLongestMatch(String path, List expected) {
        Iterator actual = new LongestMatch(path);

        for (Iterator elems=expected.iterator(); elems.hasNext(); ) {
            assertTrue("has next", actual.hasNext());
            assertEquals((String) elems.next(), (String) actual.next());
        }
        assertFalse("has next", actual.hasNext());
        try {
            actual.next();
            fail("should have thrown NoSuchElementException");
        } catch (NoSuchElementException ex) {
            ;
        }
    }
}
