/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.tools.junit.framework.BaseTestCase;

import java.math.BigInteger;

import org.apache.log4j.Logger;

public class TypesTest extends BaseTestCase {
    private static final Logger s_log =  Logger.getLogger(TypesTest.class);

    public TypesTest(String name) {
        super(name);
    }

    public void testTypes() {
        DataCollection dc = SessionManager.getSession().retrieve
            ("com.arsdigita.versioning.JavaClass");
        int count = 0;
        while (dc.next()) {
            // retrieve the matching enum constant to make sure that each type
            // in the db has a matching instance of the Types enum.
            Types.getType((BigInteger) dc.get("id"));
            count++;
        }
        assertEquals("number of types", 16, count);
    }

    public void testLiskovSubstitutability() {
        Types bigType = Types.getType(BigInteger.class);
        Types biggerType = Types.getType(BiggerInteger.class);
        Types biggestType = Types.getType(BiggestInteger.class);
        assertEquals("BiggerInteger maps to BigInteger", bigType, biggerType);
        assertEquals("BiggestInteger maps to BigInteger", bigType, biggestType);
    }

    public void testUnknownType() {
        boolean hasBeenRaised = false;
        try {
            Types.getType(TotallyRandomClass.class);
        } catch (UnknownTypeException ex) {
            hasBeenRaised = true;
        }
        assertTrue("UnknownTypeException has been properly raised", hasBeenRaised);
    }

    private static class BiggerInteger extends BigInteger {
        public BiggerInteger(String val) {
            super(val);
        }
    }

    private static class BiggestInteger extends BiggerInteger {
        public BiggestInteger(String val) {
            super(val);
        }
    }

    private static class TotallyRandomClass {}
}
