/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.tools.junit.framework.BaseTestCase;

import org.apache.log4j.Logger;

public class EventTypeTest extends BaseTestCase {
    private static final Logger s_log =  Logger.getLogger(EventTypeTest.class);

    public EventTypeTest(String name) {
        super(name);
    }

    public void testEventType() {
        DataCollection dc = SessionManager.getSession().retrieve
            ("com.arsdigita.versioning.EventType");
        int count = 0;
        while (dc.next()) {
            // retrieve the matching enum constant to make sure that each event
            // in the db has a matching instance of the EventType enum.
            EventType.getEventType(dc.getDataObject());
            count++;
        }
        assertEquals("number of event types", 5, count);
    }
}
