/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.sitenode;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.net.*;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.InputStream;
import java.io.IOException;

import junit.framework.*;

import org.apache.cactus.*;
import org.apache.cactus.util.*;

import org.apache.log4j.Logger;

import com.arsdigita.dispatcher.*;
import com.arsdigita.sitenode.*;
import com.arsdigita.initializer.*;
import com.arsdigita.util.ResourceManager;

import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.TransactionContext;


public class SiteNodeDispatcherCactusTest extends ServletTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/sitenode/SiteNodeDispatcherCactusTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    HttpServlet s;
    RequestContext rctx;

    public SiteNodeDispatcherCactusTest(String theName) {
        super(theName);
    }

    public void setUp() {

        ClassLoader cl = ClassLoader.getSystemClassLoader();

    }

    public void testSomething()
        throws javax.servlet.ServletException, java.io.IOException {

        //  s = new Tomcat32DefaultServlet();
        //  s.init(config);
        //  s.service(request, response);

        Session sm = SessionManager.getSession();
    }

    public void beginRequestContext(WebRequest req) {
        ServletURL u = req.getURL();

        req.setURL("localhost","/enterprise", "/foo", "/bar.jsp", null);
    }

    public void testRequestContext()
        throws javax.servlet.ServletException, java.io.IOException {
        final Logger s_cat =
            Logger.getLogger(SiteNodeDispatcherCactusTest.class.getName());

        s_cat.info("SiteNodeDispatcherCactusTest.testRequestContext()");

        s = new SiteNodeDispatcher() {
                public void dispatch(HttpServletRequest req,
                                     HttpServletResponse resp,
                                     RequestContext actx)
                    throws IOException, ServletException {
                    try {
                        s_cat.error("sitenodedispatchercactustest: in overrided dispatch method");
                        //          super.dispatch(req, resp, actx);
                        rctx = actx;
                    } catch (Throwable t){
                        s_cat.error("SiteNodeDispatcher error",t);
                    }
                    return;
                }
            };

        s.init(config);
        s.service(request, response);
        assertTrue(rctx != null);
        assertTrue(rctx.getOutputType() != null);
        assertEquals(rctx.getRemainingURLPart(),"/foo/bar.jsp");
        assertEquals(rctx.getProcessedURLPart(),"/enterprise");
        assertEquals(rctx.getOriginalURL(),"/enterprise/foo/bar.jsp");
        s_cat.error("All you need is \n");
        s_cat.error("SiteNodeDispatcherCactusTestLove\n");
        s_cat.error(rctx.getOriginalURL() + ", " + rctx.getRemainingURLPart()
                    + ", " + rctx.getProcessedURLPart() + "\n");
        s_cat.error(request.getRequestURI() + "\n");
    }

}
