/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.search.Search;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import org.apache.log4j.Logger;

/**
 * LuceneTestCase
 *
 * @author <a href="mailto:jorris@redhat.com">Jon Orris</a>
 *
 */
public abstract class LuceneTestCase extends BaseTestCase {

    private static Logger s_log =
            Logger.getLogger(LuceneTestCase.class);

    public LuceneTestCase(String name) {
        super(name);
    }

    protected void runTest() throws Throwable {
        if (Search.getConfig().isLuceneEnabled()) {
            super.runTest();
        }
    }
}
