/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;


/**
 * SearchTestAuthor class.  Used to test generating XML documents
 * for related objects.
 *
 * @author Jeff Teeters
 **/
public class SearchTestAuthor extends ACSObject {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/intermedia/SearchTestAuthor.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Chapters associated with this author
    DataAssociation m_chapters = null;

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.search.intermedia.SearchTestAuthor";

    public SearchTestAuthor() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SearchTestAuthor(String typeName) {
        super(typeName);
    }

    public SearchTestAuthor(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SearchTestAuthor(int key)  throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }

    public SearchTestAuthor(DataObject authorData) {
        super(authorData);
    }


    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getDisplayName() {
        return "SearchTestAuthor-DisplayName";
    }

    /* Register instantiator with DomainObjectFactory, must be called by
       initializer */
    public static void setupDomainObjectFactory() {
        DomainObjectInstantiator instantiator;

        instantiator = new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new SearchTestAuthor(dataObject);
                }
            };
        DomainObjectFactory.registerInstantiator(
                                                 SearchTestAuthor.BASE_DATA_OBJECT_TYPE,
                                                 instantiator);
    }


    public void addChapter(SearchTestChapter chapter) {
        if (m_chapters == null) {
            m_chapters = (DataAssociation) get("chapters");
        }
        chapter.addToAssociation(m_chapters);
    }

    public void removeChapter(SearchTestChapter chapter) {
        if (m_chapters == null) {
            m_chapters = (DataAssociation) get("chapters");
        }
        chapter.removeFromAssociation(m_chapters);
    }




    public String getName() {
        return (String) get("name");
    }

    public void setName(String name) {
        set("name", name);
    }
}
