/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

public class TestResultSet implements ResultSet {

    private List m_docs;
    private long m_duration;

    public TestResultSet(List docs,
                         long duration) {
        m_docs = docs;
        m_duration = duration;
    }

    public Iterator getDocuments(long offset,
                                 long count) {
        List page = new ArrayList();
        for (int i = (int)offset ; i < (int)(offset+count) && i < getCount() ; i++) {
            page.add(m_docs.get(i));
        }
        return page.iterator();
    }

    public String getEngine() {
        return SearchSuite.TEST_INDEXER.getKey();
    }

    public long getCount() {
        return m_docs.size();
    }
    
    public void close() {
        // no-op
    }

    public long getQueryTime() {
        return m_duration;
    }
    
}
