/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import org.apache.log4j.Logger;
import com.arsdigita.kernel.ACSObject;


public class RegistryTest extends BaseTestCase {

    private static Logger s_log =
            Logger.getLogger(RegistryTest.class);

    public RegistryTest(String name) {
        super(name);
    }

    public void testRegistry() throws Throwable {
        // Initial state, nothing should be found
        assertTrue(MetadataProviderRegistry.getAdapter(ACSObject.BASE_DATA_OBJECT_TYPE) == null);
        assertTrue(MetadataProviderRegistry.getAdapter(Note.BASE_DATA_OBJECT_TYPE) == null);
        assertTrue(MetadataProviderRegistry.findAdapter(Note.BASE_DATA_OBJECT_TYPE) == null);
        
        // Register bogus adapter for ACSObject
        NoteAdapter apt1 = new NoteAdapter();
        MetadataProviderRegistry.registerAdapter(ACSObject.BASE_DATA_OBJECT_TYPE,
                                                 apt1);
        assertTrue(MetadataProviderRegistry.getAdapter(ACSObject.BASE_DATA_OBJECT_TYPE) == apt1);
        assertTrue(MetadataProviderRegistry.getAdapter(Note.BASE_DATA_OBJECT_TYPE) == null);
        assertTrue(MetadataProviderRegistry.findAdapter(Note.BASE_DATA_OBJECT_TYPE) == apt1);
        
        // Register specific one for Note
        NoteAdapter apt2 = new NoteAdapter();
        MetadataProviderRegistry.registerAdapter(Note.BASE_DATA_OBJECT_TYPE,
                                                 apt2);
        assertTrue(MetadataProviderRegistry.getAdapter(ACSObject.BASE_DATA_OBJECT_TYPE) == apt1);
        assertTrue(MetadataProviderRegistry.getAdapter(Note.BASE_DATA_OBJECT_TYPE) == apt2);
        assertTrue(MetadataProviderRegistry.findAdapter(Note.BASE_DATA_OBJECT_TYPE) == apt2);
        
        // Remove the one for ACSObject
        MetadataProviderRegistry.unregisterAdapter(ACSObject.BASE_DATA_OBJECT_TYPE);
        assertTrue(MetadataProviderRegistry.getAdapter(ACSObject.BASE_DATA_OBJECT_TYPE) == null);
        assertTrue(MetadataProviderRegistry.getAdapter(Note.BASE_DATA_OBJECT_TYPE) == apt2);
        assertTrue(MetadataProviderRegistry.findAdapter(Note.BASE_DATA_OBJECT_TYPE) == apt2);
        
        // Remove the one for Note
        MetadataProviderRegistry.unregisterAdapter(Note.BASE_DATA_OBJECT_TYPE);
        assertTrue(MetadataProviderRegistry.getAdapter(ACSObject.BASE_DATA_OBJECT_TYPE) == null);
        assertTrue(MetadataProviderRegistry.getAdapter(Note.BASE_DATA_OBJECT_TYPE) == null);
        assertTrue(MetadataProviderRegistry.findAdapter(Note.BASE_DATA_OBJECT_TYPE) == null);
    }
}
