/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.auditing.AuditedACSObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

/**
 * Note
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/

class Note extends AuditedACSObject {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/Note.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.search.Note";

    public Note(BigDecimal id) {
        super(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public Note() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public static Note create(String title,
                              String text) {
        Note note = new Note();
        note.setTitle(title);
        note.setText(text);
        return note;
    }

    public String getTitle() {
        return (String) get("title");
    }

    public void setTitle(String title) {
        set("title", title);
    }

    public String getText() {
        return (String) get("text");
    }

    public void setText(String text) {
        set("text", text);
    }
}
