/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.messaging;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import java.util.Date;
import com.arsdigita.tools.junit.framework.BaseTestCase;

public class ThreadTest extends BaseTestCase {

    private MessageThread m_thread = null;
    private ThreadedMessage m_root = null;
    private Date m_updated = null;
    private long m_postPopulateNumber = 0L;

    public ThreadTest(String name) {
        super(name);
    }

    public static void main(String args[]) {
        junit.textui.TestRunner.run(ThreadTest.class);
    }

    protected void setUp() {
        m_root = new ThreadedMessage(getUser(), "subject", "body");
        m_root.save();
        m_thread = m_root.getThread();
        m_updated = m_root.getSentDate();
    }

    public void testSmoketest() {
        assertEquals(m_root, m_thread.getRootMessage());
        assertEquals(0L, m_thread.getNumReplies());
        assertEquals(m_root.getSentDate(), m_thread.getLatestUpdateDate());
        assertEquals(m_root.getFrom(), m_thread.getAuthor());
        assertEquals(m_root.getSubject(), m_thread.getSubject());
    }

    public void testThreadUpdates() {
        populateThread();
        // need to retrieve a new copy because the existing ones
        // don't get updated when the database changes
        MessageThread t = MessageThread.getFromRootMessage(m_root);

        assertEquals(m_postPopulateNumber, t.getNumReplies());

        // and this still fails because the retrieved date is
        // truncated to the second.
        //          assertEquals(m_updated,
        //                       MessageThread.getFromRootMessage(m_root)
        //                       .getLatestUpdateDate());
    }

    public void testRetrievals() {
        assertEquals(m_thread, MessageThread.getFromRootMessage(m_root));
        assertEquals(m_thread, m_root.getThread());
    }

    private User getUser() {

        String key   = String.valueOf(System.currentTimeMillis());
        String email = key + "-message-test@arsdigita.com";
        String first = key + "-message-test-given-name";
        String last  = key + "-message-test-family-name";

        User user = new User();
        user.setPrimaryEmail(new EmailAddress(email));

        PersonName name = user.getPersonName();
        name.setGivenName(first);
        name.setFamilyName(last);

        user.save();

        return user;
    }

    private void populateThread() {
        ThreadedMessage[] msgs = new ThreadedMessage[11];

        msgs[0] = m_root;

        for (int i = 1 ; i <= 10 ; i++) {
            msgs[i] = msgs[i-1].replyTo(getUser(),"body");
            //System.out.println("ThreadTest: update time is " +
            //                   m_thread.getLatestUpdateDate().getTime());
            msgs[i].save();
            m_updated = msgs[i].getSentDate();
            m_postPopulateNumber++;
        }
    }

}
