/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mail;

// JUnit classes
import junit.framework.TestCase;

// Java Core classes
import java.net.*;
import java.io.*;
import javax.mail.*;
import javax.activation.*;
import javax.mail.internet.*;

/**
 * Unit tests for the ACS Mail service MailQueue class.  Currently
 * tests are only provided for creating and storing messages in the
 * queue, but not actually sending them.
 *
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/mail/MailQueueTest.java#8 $
 */

public class MailQueueTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/mail/MailQueueTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Data for the test cases

    final static String to      = "to@somedomain.net";
    final static String from    = "from@somedomain.net";
    final static String subject = "this is the subject";
    final static String text    = "this is the body in plain text.\n";

    public MailQueueTest(String name) {
        super(name);
    }

    protected void setUp() {
        SimpleServer.startup();
    }

    /**
     * Check the API for adding messages to the queue.
     */

    public static void testMailQueue001 () {

        MailQueue queue = new MailQueue();

        for (int i = 0 ; i < 10; i++) {
            queue.addMail
                (new Mail(to, from, subject,
                          "Message " + i + ": " + text));
        }

        // Make sure they all made it
        assertTrue(queue.getCount() == 10);

        // Try sending all messages

        try {
            queue.send();
        } catch (MessagingException mex) {
            fail(mex.getMessage());
        }
    }

    /**
     * Main method required to make this test runnable.
     */

    public static void main (String args[]) {
        junit.textui.TestRunner.run(MailQueueTest.class);
    }

}
