/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import java.security.*;
import java.util.*;
import javax.crypto.*;
import junit.framework.*;

public class CryptoTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/security/CryptoTest.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public CryptoTest(String name) {
        super(name);
    }
    public static Test suite() {
        try {
            return new TestSuite(CryptoTest.class);
        } catch (final Throwable t) {
            // handles NoClassDefFoundError
            // and ExceptionInInitializerError
            return new TestCase("Create CredentialTest") {
                    public void runTest() throws Throwable {
                        throw t;
                    }
                };
        }
    }
    public void testNewMac() {
        try {
            Mac mac = Crypto.newMac();
            byte[] input = new byte[128];
            (new SecureRandom()).nextBytes(input);
            byte[] digest = mac.doFinal(input);
        } catch (GeneralSecurityException e) {
            fail("Could not calculate MAC: "+e);
        }
    }
    public void testEncryptCycle() {
        try {
            String cleartext = "this is the clear text";
            char[] password = "Password123".toCharArray();
            String ciphertext = Crypto.encrypt(cleartext, password);
            String decrypted = Crypto.decrypt(ciphertext, password);
            assertEquals("after decryption", cleartext, decrypted);
        } catch (GeneralSecurityException e) {
            fail("Could not encrypt or decrypt: "+e);
        } catch (IllegalArgumentException e) {
            fail("Could not parse ciphertext: "+e);
        }
    }
}
