/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.kernel.permissions.*;

import com.arsdigita.domain.DataObjectNotFoundException;


import com.arsdigita.tools.junit.framework.BaseTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * Test that roles work well with the permissions system
 *
 *
 * @see com.arsdigita.kernel.Role
 * @see com.arsdigita.kernel.Permission
 *
 * @author Michael Bryzek
 * @version 1.0
 **/

public class RolePermissionTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/RolePermissionTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Group m_group;
    private ArrayList m_roles;
    private String[] m_roleNames =
        new String[] { "Author", "Editor", "Administrator" };

    /**
     * Constructs a RolePermissionTest with the specified name.
     *
     * @param name Test case name.
     **/
    public RolePermissionTest( String name ) {
        super( name );
    }

    public void setUp() {
        m_group = GroupTest._createGroup("RolePermissionTest Group");
        m_group.save();

        m_roles = new ArrayList();
        for (int i=0; i<m_roleNames.length; i++) {
            Role role = RoleTest.createRole(m_group, m_roleNames[i]);
            role.addMember(RoleTest.createUser("User" + i));
            role.save();
            try {
                m_roles.add(new Role(role.getOID()));
            } catch (DataObjectNotFoundException e) {
                e.printStackTrace();
                fail("Could not retrieve role after creation");
            }

        }
    }

    public void tearDown() {
        m_group = null;
        m_roles = null;
    }


    /**
     * Tests that we can add members to various roles in a group and
     * retrieve them correctly.
     **/
    public void testAssigningPermissions() {
        // Let's grant people write permissions on a user
        ACSObject target = RoleTest.createUser("testAssigningPermissionsGrantee");
        PrivilegeDescriptor priv = PrivilegeDescriptor.WRITE;

        Iterator iter = m_roles.iterator();
        while (iter.hasNext()) {
            Role role = (Role) iter.next();
            role.grantPermission(target, priv);
            if (! role.checkPermission(target, priv) ) {
                fail("Grant of permission failed");
            }

            role.revokePermission(target, priv);
            if (role.checkPermission(target, priv) ) {
                fail("Revoke of permission failed");
            }
        }
    }


    public static Test suite() {
        return new TestSuite(RolePermissionTest.class);
    }

}
