/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;


/**
 * Example class: "forum" domain object
 *
 * @author Oumi Mehrotra 
 * @version 1.0
 **/
public class ExampleForum extends ACSObject {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/ExampleForum.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "examples.Forum";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ExampleForum(DataObject forumData) {
        super(forumData);
    }

    /**
     * Default constructor. The contained <code>DataObject</code> is
     * initialized with a new <code>DataObject</code> with an
     * <code>ObjectType</code> of "Forum".
     *
     * @see ACSObject#ACSObject(String)
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.metadata.ObjectType
     **/
    public ExampleForum() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    /**
     * Constructor in which the contained <code>DataObject</code> is
     * initialized with a new <code>DataObject</code> with an
     * <code>ObjectType</code> specified by the string
     * <i>typeName</i>.
     *
     * @param typeName the name of the <code>ObjectType</code> of the
     * contained <code>DataObject</code>
     *
     * @see ACSObject#ACSObject(ObjectType)
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.metadata.ObjectType
     **/
    public ExampleForum(String typeName) {
        super(typeName);
    }

    /**
     * Constructor in which the contained <code>DataObject</code> is
     * initialized with a new <code>DataObject</code> with an
     * <code>ObjectType</code> specified by <i>type</i>.
     *
     * @param type the <code>ObjectType</code> of the contained
     * <code>DataObject</code>
     *
     * @see ACSObject#ACSObject(ObjectType)
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.metadata.ObjectType
     **/
    public ExampleForum(ObjectType type) {
        super(type);
    }

    /**
     * Constructor in which the contained <code>DataObject</code> is retrieved
     * from the persistent storage mechanism with an <code>OID</code>
     * specified by <i>oid</i>.
     *
     * @param oid the <code>OID</code> for the retrieved
     * <code>DataObject</code>
     *
     * @see ACSObject#ACSObject(OID)
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.OID
     **/
    public ExampleForum(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    /**
     * Returns a display name for this Forum.
     *
     * @see ACSObject#getDisplayName()
     */
    public String getDisplayName() {
        return (String) get("name");
    }

    public void setDisplayName(String name) {
        set("name", name);
    }

    public PackageInstance getPackageInstance() {
        return new PackageInstance((DataObject) get("packageInstance"));
    }

    public void setPackageInstance(PackageInstance packageInstance) {
        setAssociation("packageInstance", packageInstance);
    }

    // The default getContainer and isContainerModified implementations
    // should work, but to make debugging easier, I am leaving these
    // domain-specific implementations here, but commented out.
    /*
      protected ACSObject getContainer() {
      return getPackageInstance();
      }

      protected boolean isContainerModified() {
      return isPropertyModified("packageInstance");
      }
    */

    public ExampleMessageCollection getMessages() {
        return new ExampleMessageCollection((DataAssociation)get("messages"));
    }

}
