/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * Test for MessageCatalog DomainObject
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class MessageCatalogTest extends BaseTestCase {
    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/globalization/MessageCatalogTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Construct a MessageCatalogTest with the specified name.
     *
     * @param name
     */
    public MessageCatalogTest(String name) {
        super(name);
    }

    /**
     * Test persistence of MessageCatalog DomainObject.
     */
    public void testPersistence() throws Exception {
        String bundleName = getClass().getName();
        java.util.Locale locale = new java.util.Locale("es", "", "");
        String key1 = "key1";
        String message1 = "message1";
        String key2 = "key2";
        String message2 = "message2";
        String key3 = "key3";
        String message3 = "message3";

        Map map = new HashMap();

        map.put(key1, message1);
        map.put(key2, message2);
        map.put(key3, message3);

        // create a MessageCatalog object and save it to the database.
        MessageCatalog catalog = new MessageCatalog(bundleName);
        catalog.setMap(map);
        catalog.save();

        // retrieve the MessageCatalog object we just created and make sure
        // all values are what we expect.
        catalog = MessageCatalog.retrieve(bundleName);
        map = catalog.getMap();

        assertEquals(
                     "Messages don't match",
                     message1,
                     (String) map.get(key1)
                     );
    }
}
