/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import java.util.Locale;

/**
 * <p>
 * Testing the GlobalizedMessage class.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class GlobalizedMessageTest extends BaseTestCase {
    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/globalization/GlobalizedMessageTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String bundleName = "com.arsdigita.globalization.GMBundle";
    private final static Locale l_en = new Locale("en", "", "");
    private final static Locale l_es = new Locale("es", "", "");

    public GlobalizedMessageTest(String name) {
        super(name);
    }

    public void test1() throws Exception {
        String key = "key.1";
        String message_en = "message.1";
        String message_es = "mensaje.1";

        GlobalizedMessage gm = new GlobalizedMessage(key, bundleName);

        assertEquals("message_en", message_en, (String) gm.localize(l_en));
        assertEquals("message_es", message_es, (String) gm.localize(l_es));
    }

    public void test2() throws Exception {
        String key = "key.2";
        String message_en = "This is a red wine.";
        String message_es = "Este es un vino rojo.";
        Object[] args = new Object[] {
            new GlobalizedMessage("key.3", bundleName)
        };

        GlobalizedMessage gm = new GlobalizedMessage(key, bundleName, args);

        assertEquals("message_en", message_en, (String) gm.localize(l_en));
        assertEquals("message_es", message_es, (String) gm.localize(l_es));
    }

    public void test3() throws Exception {
        String key = "key.4";
        String message_en = "message.4";
        String message_es = "mensaje.4";
        Object[] args = null;

        GlobalizedMessage gm = new GlobalizedMessage(key, bundleName, args);

        assertEquals("message_en", message_en, (String) gm.localize(l_en));
        assertEquals("message_es", message_es, (String) gm.localize(l_es));
    }

    public void test4() throws Exception {
        String key = "key.5";
        String message_en = "message.5";
        String message_es = "mensaje.5";
        Object[] args = new Object[] { null };

        GlobalizedMessage gm = new GlobalizedMessage(key, bundleName, args);

        assertEquals("message_en", message_en, (String) gm.localize(l_en));
        assertEquals("message_es", message_es, (String) gm.localize(l_es));
    }

    public void test5() throws Exception {
        String key = "key.6";
        String message_en = "message.null.6";
        String message_es = "mensaje.null.6";
        Object[] args = new Object[] { null };

        GlobalizedMessage gm = new GlobalizedMessage(key, bundleName, args);

        assertEquals("message_en", message_en, (String) gm.localize(l_en));
        assertEquals("message_es", message_es, (String) gm.localize(l_es));
    }
}
