/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.tools.junit.framework.BaseTestCase;

/**
 * <p>
 * Test for Charset DomainObject
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class CharsetTest extends BaseTestCase {
    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/globalization/CharsetTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Construct a CharsetTest with the specified name.
     *
     * @param name
     */
    public CharsetTest(String name) {
        super(name);
    }

    /**
     * Test persistence of Charset DomainObject.
     */
    public void testPersistence() throws Exception {
        String charsetName = "YON-XXXX";

        // create a Charset object and save it to the database.
        Charset charset = new Charset();
        charset.setCharset(charsetName);
        charset.save();

        OID charsetOID = charset.getOID();

        // retrieve the Charset object we just created and make sure
        // all values are what we expect.
        try {
            charset = new Charset(charsetOID);
        } catch (DataObjectNotFoundException e) {
            fail("the character set was not created properly or could not be retrieved");
        }

        assertEquals(
                     "Character sets don't match",
                     charsetName,
                     charset.getCharset()
                     );
    }
}
