/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// Interface of the class that we are testing
import com.arsdigita.formbuilder.PersistentComponentFactory;

// The class we are testing
import com.arsdigita.formbuilder.PersistentTextField;

// Interfaces used by the base test case
import com.arsdigita.bebop.Component;

// For reference
import com.arsdigita.bebop.form.TextField;

// logging
import org.apache.log4j.Logger;


/**
 * Test the PersistentTextField class with the test pattern defined in
 * PersistentComponentTestCase.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentTextFieldTest.java#9 $
 */
public class PersistentTextFieldTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentTextFieldTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private final static Logger s_log =
        Logger.getLogger(PersistentTextFieldTest.class.getName());

    // Properties of the text area
    private static String m_htmlName = "Test Text Field Name";
    private static String m_defaultValue = "Test text field Default Value";
    private static int m_size = 20;
    private static int m_maxLength = 50;

    /**
     * JUnit needs this constructor
     */
    public PersistentTextFieldTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        PersistentTextField factory =
            PersistentTextField.create(m_htmlName);

        factory.setDefaultValue(m_defaultValue);
        factory.setSize(m_size);
        factory.setMaxLength(m_maxLength);

        return factory;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {
        TextField textField = new TextField(m_htmlName);

        textField.setDefaultValue(m_defaultValue);
        textField.setSize(m_size);
        textField.setMaxLength(m_maxLength);

        return textField;
    }

    // We do not override the checkPersistenceAttributes() method since we keep
    // no persistence specific attributes for the TextField
}
