/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// Testing remove:
import com.arsdigita.formbuilder.PersistentTextArea;

// Reference
import com.arsdigita.bebop.Form;

// logging
import org.apache.log4j.Logger;

// Used to instantiate objects
import com.arsdigita.formbuilder.util.FormBuilderUtil;

import java.lang.reflect.Method;

// When we catch exceptions that we cannot deal with
import com.arsdigita.util.UncheckedWrapperException;


/**
 * Test case for the ComponentPropertiesForm class.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/ComponentPropertiesFormTest.java#9 $
 *
 */
public class ComponentPropertiesFormTest
    extends com.arsdigita.tools.junit.framework.BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/ComponentPropertiesFormTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private final static Logger s_log =
        Logger.getLogger(ComponentPropertiesFormTest.class.getName());

    /**
     * JUnit needs this constructor
     */
    public ComponentPropertiesFormTest(String name) {
        super(name);
    }

    public void testComponentPropertiesForm() {

        // Workaround for "(root cause: Request context does not subclass KernelRequestContext:
        // com.arsdigita.formbuilder.test.DummyRequestContext)"
        com.arsdigita.util.URLRewriter.clearParameterProviders();

        // Construct a new instance
        try {

            // Assertions:
            // There is a default constructor
            // The object implements AttributeMetaDataProvider
            // The object is either a DomainObject or implements FormProcessListener

            // Get the class
            String className = "com.arsdigita.formbuilder.PersistentTextArea";
            Class classObject = Class.forName(className);

            // Create a new instance with the default constructor
            Object objectInstance = classObject.newInstance();

            // Properties that will be extracted from the FormData
            String attributeName1 = "parameterName";
            String attributeValue1 = "parameterName value";
            String attributeName2 = "cols";
            String attributeValue2 = "30";

            // Set the attributes
            invokeSetMethod(objectInstance, attributeName1, attributeValue1);
            invokeSetMethod(objectInstance, attributeName2, attributeValue2);

            // Save the domain object
            Method saveMethod = classObject.getMethod("save", new Class[] {});
            saveMethod.invoke(objectInstance, new Object[] {});

        } catch (Exception e) {

            throw new UncheckedWrapperException(e);
        }

    }

    private void invokeSetMethod(Object object, String attributeName, String attributeValue)
        throws IllegalAccessException, java.lang.reflect.InvocationTargetException {

        Object valueObject = attributeValue;

        Method[] methods = object.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {

            Method method = methods[i];

            // Upper case the first letter of the attribute name
            String setMethodName = "set" + attributeName.substring(0,1).toUpperCase() + attributeName.substring(1);

            if (method.getName().equals(setMethodName)) {

                Class[] parameterTypes = method.getParameterTypes();

                s_log.debug("method name " + method.getName() + " parameterType " + parameterTypes[0].getName());

                // Unfortunately the reflection API doesn't do data type conversion
                // so we need to handle this ourselves
                String typeName = parameterTypes[0].getName();
                if (typeName.equals("int")) {
                    valueObject = new Integer(attributeValue);
                }

                method.invoke(object, new Object[] {valueObject});
            }
        }
    }
}
