/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.*;
import com.arsdigita.persistence.pdl.*;
import junit.framework.*;

import java.util.HashSet;
import java.util.Set;

/**
 * DomainTestCase: Provides a framework for domain test cases requiring the
 * loading of PDL files, database connections, and other persistence services.
 *
 * This class is essentially a copy of PersistenceTestCase. Due to the current
 * development setup, PersistenceTestCase is not available for use by clients
 * outside persistence/test/src
 *
 * @author Jon Orris
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class DomainTestCase extends TestCase {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/domain/DomainTestCase.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Prevent loading the same PDL file twice
    private static Set m_loadedPDLResources = new HashSet();

    protected static void load(String resource) {
        if (m_loadedPDLResources.contains(resource)) {
            return;
        }
        try {
            PDL m = new PDL();
            m.loadResource(resource);
            m.generateMetadata(SessionManager.getMetadataRoot());
        } catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        m_loadedPDLResources.add(resource);
    }


    public DomainTestCase(String name) {
        super(name);
    }

    /**
     * Runs the bare test sequence.
     *
     * @exception Throwable if any exception is thrown
     **/

    public void runBare() throws Throwable {
        domainSetUp();
        try {
            super.runBare();
        } finally {
            domainTearDown();
        }
    }

    protected void domainSetUp() {
        m_session = SessionManager.getSession();
        m_session.getTransactionContext().beginTxn();
    }

    protected void domainTearDown() {
        m_session = SessionManager.getSession();
        if (m_session.getTransactionContext().inTxn()) {
            m_session.getTransactionContext().abortTxn();
        }
    }

    protected Session getSession()
    {
        return m_session;
    }

    private Session m_session;

}
